package kochModel.factory;

import kochModel.*;
import lrs.*;
import java.awt.geom.Point2D.Double;

public class Tree2FractalFactory extends FractalFactory {
  
  public Tree2FractalFactory() {
    Double p0 = new Double(0.0,0.0);
    Double p1 = new Double(1.0,0.0);
    Double p2 = new Double(1.5, 1.0/3.0*Math.sqrt(3.0)/2.0);
    Double p3 = new Double(1.0, Math.sqrt(1.0/3.0));
    Double p4 = new Double(0.5, 1.0/3.0*Math.sqrt(3.0)/2.0);
    
    LRStruct<Koch> children = new LRStruct<Koch>();
    children.insertFront(new Koch(p1, p2));
    children.insertFront(new Koch(p1, p3));
    children.insertFront(new Koch(p1, p4));
    
    setProto(new Koch(p0, p1, children));
  }
}
